package org.msh.tb.entities;

import org.msh.etbm.commons.transactionlog.Operation;
import org.msh.etbm.commons.transactionlog.mapping.PropertyLog;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name="synchronizationsummary")
public class SynchronizationSummary {

    @Id
    @GeneratedValue(strategy= GenerationType.AUTO)
    private Integer id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "TBUNIT_ID")
    @PropertyLog(operations = {Operation.NEW, Operation.DELETE})
    private Tbunit tbunit;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "WORKSPACE_ID")
    @PropertyLog(operations = {Operation.NEW, Operation.DELETE})
    private Workspace workspace;

    private String userName;

    private String userLogin;

    private Date execDate;

    private Integer tbcasesCreated;

    private Integer tbcasesUpdated;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Tbunit getTbunit() {
        return tbunit;
    }

    public void setTbunit(Tbunit tbunit) {
        this.tbunit = tbunit;
    }

    public Workspace getWorkspace() {
        return workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserLogin() {
        return userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public Date getExecDate() {
        return execDate;
    }

    public void setExecDate(Date execDate) {
        this.execDate = execDate;
    }

    public Integer getTbcasesCreated() {
        return tbcasesCreated;
    }

    public void setTbcasesCreated(Integer tbcasesCreated) {
        this.tbcasesCreated = tbcasesCreated;
    }

    public Integer getTbcasesUpdated() {
        return tbcasesUpdated;
    }

    public void setTbcasesUpdated(Integer tbcasesUpdated) {
        this.tbcasesUpdated = tbcasesUpdated;
    }
}
